<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Deposit Request</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 6px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #3490dc;
            color: #fff;
            padding: 20px;
            text-align: center;
            border-radius: 6px 6px 0 0;
            margin-bottom: 20px;
        }
        .content {
            padding: 20px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #777;
            font-size: 12px;
        }
        .amount {
            font-size: 24px;
            font-weight: bold;
            color: #3490dc;
        }
        .info-box {
            background-color: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 4px;
            padding: 15px;
            margin: 15px 0;
        }
        .button {
            display: inline-block;
            background-color: #3490dc;
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 4px;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Deposit Request</h1>
        </div>
        <div class="content">
            <p>Dear Admin,</p>
            
            <p>A new deposit request has been submitted by a user. Please review the details below:</p>
            
            <div class="info-box">
                <p><strong>User:</strong> <?php echo e($user->name); ?> (<?php echo e($user->email); ?>)</p>
                <p><strong>Amount:</strong> <span class="amount"><?php echo e($user->currency); ?><?php echo e(number_format($deposit->amount, 2)); ?></span></p>
                <p><strong>Payment Method:</strong> <?php echo e($deposit->payment_mode); ?></p>
                <p><strong>Date:</strong> <?php echo e($deposit->created_at->format('M d, Y H:i')); ?></p>
                <p><strong>Status:</strong> Pending</p>
            </div>
            
            <p>A payment proof has been uploaded by the user. Please log in to the admin dashboard to review and process this deposit request.</p>
            
            <p>Best regards,<br>Your System</p>
        </div>
        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Your Company. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/karamelh/public_html/zillship.karamelscript.com.ng/resources/views/emails/admin-deposit-notification.blade.php ENDPATH**/ ?>